const notes = await api.runOnBackend(() => {
    return api.sql.getRows(`
        SELECT
            notes.noteId,
            COUNT(attributes.attributeId) AS count
        FROM notes
        JOIN attributes ON attributes.value = notes.noteId
        WHERE notes.isDeleted = 0
          AND attributes.isDeleted = 0
          AND attributes.type = 'relation'
        GROUP BY notes.noteId
        ORDER BY count DESC
        LIMIT 100`);
});

const $statsTable = api.$container.find('.stats-table');

for (const note of notes) {     
    $statsTable.append(
        $("<tr>")
            .append(
                $("<td>").append(await api.createNoteLink(note.noteId, {showNotePath: true}))
            ) 
            .append($("<td nowrap>").text(note.count))
    );
}